



### 实验名称

MongoDB 基本操作

### 实验目的

1.  掌握 MongoDB 数据库基本操作
    
2.  掌握 MongoDB 集合操作
    
3.  掌握 MongoDB 文档基本操作 - 增删改
    

### 实验背景

MongoDB 是一个开源文档数据库，提供高性能，高可用性和自动扩展，旨在为 Web 应用提供可扩展的高性能数据存储解决方案。

MongoDB 中的记录是一个文档，它是由字段和值（field => value）对组成的数据结构。 MongoDB 文档与 JSON 对象相似。字段的值可能包括其他文档、数组和文档数组。

![03-2-1-原理.png](./pic/03-2-1-原理.png)

在 MongoDB 中基本的概念是文档（document）、集合（collection）、数据库（database）。

| SQL 术语/概念 | MongoDB 术语/概念 | 解释/说明                                |
| ------------- | ----------------- | ---------------------------------------- |
| database      | database          | 数据库                                   |
| table         | collection        | 数据库表/集合                            |
| row           | document          | 记录、行/文档                            |
| column        | field             | 字段、属性、列/字段                      |
| index         | index             | 索引                                     |
| table join    | embedded document | 表连接/嵌套文档                          |
| primary key   | \_id              | 主键，MongoDB 自动将 \_id 字段设置为主键 |

例如：

![03-2-2-原理.png](./pic/03-2-2-原理.png)

文档的数据结构和 JSON 基本一样。

所有存储在集合中的数据都是 BSON 格式。

BSON 是一种类 JSON 的一种二进制形式的存储格式，Binary JSON，简称 BSON。

### 实验原理

基于Ubuntu 18.04 下 MongoDB 的基本操作，包括数据库操作、集合操作以及文档操作。

### 实验环境

Ubuntu 18.04

MongoDB：6.0.8

### 建议课时

1课时

### 实验步骤

题目一：MongoDB 数据库操作

1. 进入 mongodb shell

   （1）在指定目录下创建 mongodb 文件夹、其子文件夹 data、log 以及文件 mongodb.log

      ```sh
   cd /home/ubuntu
   mkdir -p mongodb/data
   mkdir -p mongodb/log
   touch mongodb/log/mongodb.log
      ```

   （2）执行 mongod 命令以启动 mongod 服务

   ```sh
   mongod --dbpath /home/ubuntu/mongodb/data --logpath /home/ubuntu/mongodb/log/mongodb.log --logappend --fork
   ```

   （3）执行 mongosh 命令进入 mongodb shell（注意：这里 mongod 服务已经启动）

   ```sh
   mongosh
   ```

   ![03-2-3-mongosh.png](./pic/03-2-3-mongosh.png)

2. 创建数据库

   MongoDB 创建数据库的语法格式如下：

   `use "DATABASE_NAME"`

   如果数据库不存在，则创建数据库；如果存在，则直接切换到指定数据库。

   例如：创建数据库 Employee

   ```js
   use Employee
   db
   ```

   ![03-2-4-创建数据库.png](./pic/03-2-4-创建数据库.png)

   如果想查看所有数据库，可以使用命令

   ```js
   show dbs
   ```

   ![03-2-5-查看所有数据库.png](./pic/03-2-5-查看所有数据库.png)

   可以看到，刚创建的数据库 Employee 并不在数据库的列表中，这是因为在 MongoDB 中数据库和集合的创建都属于懒创建，要显示它们，向 Employee 数据库中插入一些数据即可

   ```js
   db.EmployeeCollection.insertOne({name: 'google'})
   show dbs
   ```

   ![03-2-6-显示数据库.png](./pic/03-2-6-显示数据库.png)

   MongoDB 中默认的数据库为 test，如果没有创建新的数据库，集合将默认存放在 test 数据库中。

3. 删除数据库

   MongoDB 删除数据库的语法格式如下：

   `db.dropDatabase()`

   表示删除**当前**数据库，默认为 test，可以使用 db 命令查看当前数据库名。

   首先，使用 show dbs 查看所有数据库，然后用 use 切换到数据库 Employee，再进行删除数据库的操作，最后使用 show dbs 查看数据库是否删除成功，注意：一定要先使用 use 命令切换到想要删除的数据库之后再进行删除操作，否则会出错。

   ![03-2-7-删除数据库.png](./pic/03-2-7-删除数据库.png)

题目二：集合操作

1. 显式创建集合

   命令格式：`db.createCollection(name, options)`

   例如在 myDB 数据库下创建 myCollection 集合，**注意**：首先创建数据库，然后再创建集合

   ```js
   use myDB
   db.createCollection('myCollection')
   ```

   ![03-2-8-创建集合.png](./pic/03-2-8-创建集合.png)

2. 重命名集合

   对集合重命名使用 renameCollection() 方法，将 myCollection 改名为 myColl

   ```js
   db.myCollection.renameCollection('myColl')
   ```

   ![03-2-9-重命名集合.png](./pic/03-2-9-重命名集合.png)

3. 查询所有集合

   查询数据库中所有的集合使用 show collections 命令

   ```js
   show collections
   ```

   ![03-2-10-查询所有集合.png](./pic/03-2-10-查询所有集合.png)

4. 删除集合

   删除集合使用 drop() 方法

   ![03-2-11-删除集合.png](./pic/03-2-11-删除集合.png)

题目三：文档操作

1. 插入文档

   MongoDB 使用 insertOne() 或 insertMany() 方法向集合中插入文档，语法如下：`db.COLLECTION_NAME.insertOne(document)` 或 `db.COLLECTION_NAME.insertOneMany(documents)`

   示例：向数据库 student 的 stuinfo 集合插入以下数据，**注意**：先创建数据库和集合，再进行文档操作

   | \_id | name  | age  |
   | ---- | ----- | ---- |
   | 001  | alice | 18   |
   | 002  | nancy | 19   |
   | 003  | harry | 18   |
   | 004  | curry | 19   |

   （1）insertOne() 方法插入单个文档

   ```js
   db.stuinfo.insert({_id: 001, name: 'alice', age: 18})
   ```

   （2）insertMany() 方法插入多个文档

   ```js
   db.stuinfo.insertMany([{_id: 002, name: 'nancy', age: 19}, {_id: 003, name: 'harry', age: 18}, {_id: 004, name: 'curry', age:19}])
   ```

   （3）文档插入完成后，使用 find() 方法查看集合数据

   ```js
   db.stuinfo.find({})
   ```

   具体操作步骤如图所示：

   ![03-2-12-文档插入.png](./pic/03-2-12-文档插入.png)

   **注意**：以上示例中 stuinfo 是我们的集合名，如果该集合不在该数据库中， MongoDB 会自动创建该集合并插入文档，称之为**隐式创建集合**。

   还可以先将文档定义为一个变量，再进行插入

   ```js
   s = {_id: 005, name: 'queen', age: 17}
   db.stuinfo.insertOne(s)
   db.stuinfo.find({})
   ```

   操作结果如图所示：

   ![03-2-13-定义变量文档插入.png](./pic/03-2-13-定义变量文档插入.png)

2. 更新文档

   MongoDB 使用 updateOne() 和 updateMany() 方法来更新集合中的文档。

   （1）updateOne() 方法用于更新单条文档。语法格式如下：

   `db.collection.updateOne(<query>, <objNew>)`

   参数说明：

   **query**：update 的查询条件，类似 sql update 查询内 where 后面的语句。

   **objNew**： update 的对象和一些更新的操作符等，可以理解为 sql update 查询内 set 后面的语句。

   示例：通过 updateOne() 方法来更新 stuinfo 文档的姓名（name），将姓名 name 为 nancy 的文档更新为 "king"。

   首先，提前插入 \_id 为 006 和 \_id 为 007 的文档

   ```js
   db.stuinfo.insertOne({_id: 006, name: 'nancy', age: 20})
   db.stuinfo.insertOne({_id: 007, name: 'nancy', age: 21})
   ```

   ![03-2-14-提前插入.png](./pic/03-2-14-提前插入.png)

   然后，执行更新命令

   ```js
   db.stuinfo.updateOne({name: 'nancy'}, {$set: {name: 'king'}})
   ```

   通过 find({}) 查看修改是否成功

   ```js
   db.stuinfo.find({})
   ```

   具体操作步骤如图所示：

   ![03-2-15-更新单条.png](./pic/03-2-15-更新单条.png)

   以上**语句 updateOne() 只会修改第一条发现的文档**，如果要修改多条相同的文档，则需要使用 updateMany() 方法。

   （2）updateMany() 方法用于更新单条文档。语法格式如下：

   `db.collection.updateMany(<query>, <objNew>)`

   参数说明：

   **query**：update 的查询条件，类似 sql update 查询内 where 后面的语句。

   **objNew**： update 的对象和一些更新的操作符等，可以理解为 sql update 查询内 set 后面的语句。

   示例：如将姓名 name 为 “nancy” 的所有文档更新为 “joker”

   ```js
   db.stuinfo.updateMany({name: 'nancy'}, {$set: {name: 'joker'}})
   ```

   操作结果如图所示：

   ![03-2-16-更新多条.png](./pic/03-2-16-更新多条.png)

   

   （3）更多示例（**选做**）

   利用循环批量插入文档

   ```js
   for(var i = 1; i <= 10; i++) db.col.insert({count: i, test2: false, test5: true})
   ```

   ![03-2-17-循环插入-1.png](./pic/03-2-17-循环插入-1.png)

   ![03-2-17-循环插入-2.png](./pic/03-2-17-循环插入-2.png)

   更新第一条计数 count 大于1的文档的测试2 test2 为 OK

   ```js
   db.col.updateOne({"count": {$gt: 1}}, {$set: {"test2": "OK"}})
   ```

   ![03-2-18-更多示例-更新第一条-1.png](./pic/03-2-18-更多示例-更新第一条-1.png)

   ![03-2-18-更多示例-更新第一条-2.png](./pic/03-2-18-更多示例-更新第一条-2.png)

   更新多条计数 count 大于3的文档的测试2 test2 为 OK

   ```js
   db.col.updateMany({"count": {$gt: 3}}, {$set: {"test2": "OK"}})
   ```

   ![03-2-19-更多示例-更新多条-1.png](./pic/03-2-19-更多示例-更新多条-1.png)

   ![03-2-19-更多示例-更新多条-2.png](./pic/03-2-19-更多示例-更新多条-2.png)

   使用 $inc 操作符更新测试 test2 为 OK 的计数 count **都**加1

   ```js
   db.col.updateMany({test2: 'OK'}, {$inc: {count: 1}})
   ```

   ![03-2-20-更多示例-inc操作符-1.png](./pic/03-2-20-更多示例-inc操作符-1.png)

   ![03-2-20-更多示例-inc操作符-2.png](./pic/03-2-20-更多示例-inc操作符-2.png)

3. 删除文档

   deleteOne() 和 deleteMany() 方法可以用来移除集合中的数据。

   语法格式为：

   `db.COLLECTION_NAME.deleteOne(<query>)` 或 `db.COLLECTION_NAME.deleteMany(<query>)`

   参数说明：

   **query**：delete 的查询条件，类似 sql delete 查询内 where 后面的语句。

   （1）删除集合 col 下全部文档

   ```js
   db.col.deleteMany({})
   ```

   具体操作如图所示：

   ![03-2-21-删除所有文档.png](./pic/03-2-21-删除所有文档.png)

   （2）删除指定条件的文档

   删除集合 stuinfo 中姓名 name 为 joker 的全部文档

   ```js
   db.stuinfo.deleteMany({name: 'joker'})
   ```

   ![03-2-22-删除多条文档.png](./pic/03-2-22-删除多条文档.png)

   删除年龄 age 为 18 的第一个文档：

   ```js
   db.stuinfo.deleteOne({age: 18})
   ```

   ![03-2-23-删除单条文档.png](./pic/03-2-23-删除单条文档.png)

### 实验总结

通过本次实验，掌握 Ubuntu18.04 下 MongoDB 6.0.8 的数据库、集合的基本操作以及文档基本操作，包括增删改。

